-- Towns 1.2.1.0
--  2012-2018 Tsd
--  2018-2026 RoLex
-- Rest in peace Tsd and Xam
-- Town list by KCAHDEP

conf = {
	nick = "# ",		-- play room nick
	menu = ".:: ",	-- user menu name
	file = "towns.txt",		-- town list file
	lang = "ru",			-- used language
	trig = {				-- usage commands
		main = "+towns",
		work = "work",
		mode = "mode",
		list = "list",
		best = "best",
		help = "help"
	},
	clas = 5,				-- administrator class
	help = 3,				-- number of hints
	hint = 60,				-- time before hint in seconds
	exit = 120,				-- time before stop in seconds
	best = 10,				-- number of best players
	chat = false,			-- play mode by default
	talk = true,			-- allow talk in room mode
	prox = false
}

lang = {
	en = {					-- english
		room = "Game was started in play room mode.",
		chat = "Game was started in main chat mode.",
		vers = "%s is available for play, it includes %d town names.",
		mode = "The game is available in main chat mode for all users and play room mode for selected players.",
		star = "To start the game write any town name in corresponding chat.",
		quit = "To leave or enter the game write following command in chat: %s",
		stop = "If nobody is playing after a hint, the game will be stopped after %d seconds.",
		miss = "Game was stopped because nobody is playing, to start again write any town name in corresponding chat.",
		lett = "Game was stopped because no more towns were found, to start again write any town name in corresponding chat.",
		exit = "Player with score %d and %d left the game: %s",
		play = "Player with score %d and %d entered the game: %s",
		same = "%s: Given town was already named in this game.",
		next = "%s: Town name accepted: %s, you score is %d and %d, next town starts with: %s",
		hint = "Hint for all: %s, next town starts with: %s",
		best = "%d best players",
		list = "Players list",
		left = "Left players list",
		many = "Too many players in list.",
		none = "No players in list.",
		clas = "You are not administrator.",
		load = "Game was stopped by administrator.",
		help = "Command list",
		chan = "Change game mode",
		leav = "Leave or enter game",
		stat = "Player statistics",
		work = "Turn game off and on",
		prox = "You're not allowed to play due to public proxy detection of your IP address."--,
		--soon = "Your answer will be delayed for proxy lookup of your IP address."
	},
	ru = {					-- russian
		room = "     .",
		chat = "     .",
		vers = "%s   ,     %d  .",
		mode = "               .",
		star = "         .",
		quit = "          : %s",
		stop = "     ,     %d .",
		miss = "     ,         .",
		lett = "     ,         .",
		exit = "  %d  %d   : %s",
		play = " c %d  %d    : %s",
		same = "%s:       .",
		next = "%s:   : %s,    %d  %d ,    : %s",
		hint = "  : %s,    : %s",
		best = "%d  ",
		list = " ",
		left = "  ",
		many = "    .",
		none = "   .",
		clas = "   .",
		load = "  .",
		help = " ",
		chan = "  ",
		leav = "    ",
		stat = " ",
		work = "   ",
		prox = "         IP    ."--,
		--soon = "        IP    ."
	}
}

sets = {					-- dont touch this
	load = true,
	hint = 0,
	town = {},
	play = {},
	stat = {},
	stal = {},
	prox = {},
	lett = "",
	vers = "",
	last = 0,
	name = 0,
	user = 0
}

function lower (data)
	local back = ""

	for pos = 1, # data do
		local char = data:sub (pos, pos)
		local byte = char:byte ()

		if byte == 168 then
			char = string.char (byte + 16)
		elseif byte >= 192 and byte <= 223 then
			char = string.char (byte + 32)
		end

		back = back .. char
	end

	return back:lower ()
end

function upper (data)
	local back = ""

	for pos = 1, # data do
		local char = data:sub (pos, pos)
		local byte = char:byte ()

		if byte == 184 then
			char = string.char (byte - 16)
		elseif byte >= 224 and byte <= 255 then
			char = string.char (byte - 32)
		end

		back = back .. char
	end

	return back:upper ()
end

function next (word)
	local lett, keep = "", false

	for pos = # word, 1, -1 do
		lett = word:sub (pos, pos)

		if sets.town [lett] then
			for town, same in pairs (sets.town [lett]) do
				if not same then
					keep = true
					break
				end
			end
		end

		if keep then
			break
		end
	end

	if not keep then
		stop (lang [conf.lang].lett)
	end

	return lett
end

function stats (nick, priv)
	if nick then
		local _, rows = VH:SQLQuery ("select * from `lua_towns_stat` order by `score` desc limit " .. _tostring (conf.best))

		if rows > 0 then
			local list = ""

			for row = 0, rows - 1 do
				local _, user, scor = VH:SQLFetch (row)
				list = list .. " " .. _tostring (row + 1) .. ". " .. user .. " @ " .. _tostring (scor) .. "\r\n"
			end

			reply (lang [conf.lang].best:format (rows) .. ":\r\n\r\n" .. list, nick, priv)

		else
			reply (lang [conf.lang].none, nick, priv)
		end

		return
	end

	local stat = {}

	for user, scor in pairs (sets.stat) do
		table.insert (stat, {
			["user"] = user,
			["scor"] = scor
		})
	end

	if # stat == 0 then
		return
	end

	table.sort (stat, function (one, two)
		return one.scor > two.scor
	end)

	local list, best = "", 0

	for _, data in pairs (stat) do
		best = best + 1
		list = list .. " " .. _tostring (best) .. ". " .. data.user .. " @ " .. _tostring (data.scor) .. " / " .. _tostring (sets.stal [data.user] or 0) .. "\r\n"

		if best >= conf.best then
			break
		end
	end

	chat (lang [conf.lang].best:format (best) .. ":\r\n\r\n" .. list)
end

function stop (data, quit)
	chat (data)
	stats ()

	local rand = {}

	for _, list in pairs (sets.town) do
		for town, _ in pairs (list) do
			table.insert (rand, town)
		end
	end

	for pos = # rand, 1, -1 do
		local new = math.random (pos)
		rand [pos], rand [new] = rand [new], rand [pos]
	end

	sets.town = {}

	for _, town in pairs (rand) do
		local lett = town:sub (1, 1)

		if not sets.town [lett] then
			sets.town [lett] = {}
		end

		sets.town [lett][town] = false
	end

	sets.play, sets.stat, sets.lett, sets.hint, sets.user = {}, {}, "", 0, 0

	if quit then
		VH:UnRegBot (conf.nick)
		sets.load = false
	end
end

function chat (data, user)
	local _, list = VH:GetNickList ()

	for nick in list:sub (11):gmatch ("[^ %$]+") do
		if not bot (nick) then
			if conf.chat then -- chat mode
				if not sets.play [nick] and VH:IsChatUser (nick) then
					VH:SendToUser ("<" .. (user or conf.nick) .. "> " .. nmdc (data) .. "|", nick)
				end

			else -- room mode
				if sets.play [nick] and nick ~= user then -- skip self
					VH:SendToUser ("$To: " .. nick .. " From: " .. conf.nick .. " $<" .. (user or conf.nick) .. "> " .. nmdc (data) .. "|", nick)
				end
			end
		end
	end

	if conf.chat and not user then -- catch in ledokol
		VH:ScriptCommand ("chat_to_all", "<" .. conf.nick .. "> " .. data)
	end
end

function reply (data, nick, priv, user)
	if priv then -- room mode
		VH:SendToUser ("$To: " .. nick .. " From: " .. (user or conf.nick) .. " $<" .. (user or conf.nick) .. "> " .. nmdc (data) .. "|", nick)

	elseif VH:IsChatUser (nick) then -- chat mode
		VH:SendToUser ("<" .. (user or conf.nick) .. "> " .. nmdc (data) .. "|", nick)
	end
end

function bot (nick)
	if nick == VH.HubSec or nick == VH.OpChat then
		return true
	end

	if VH.GetLuaBots then
		local list = VH:GetLuaBots ()

		if list then
			for _, user in pairs (list) do
				if nick == user ["sNick"] then
					return true
				end
			end
		end
	end

	return false
end

function class (nick)
	local _, clas = VH:GetUserClass (nick)
	return tonumber (clas or -2) or -2
end

function nmdc (data)
	local back = data
	back = back:gsub ("%$", "&#36;")
	back = back:gsub ("|", "&#124;")
	return back
end

function sql (data)
	local back = data
	back = back:gsub (string.char (92), string.char (92, 92))
	back = back:gsub (string.char (34), string.char (92, 34))
	back = back:gsub (string.char (39), string.char (92, 39))
	return back
end

function _tostring (data)
	if type (data) == "number" then
		return string.format ("%d", data)
	end

	return tostring (data)
end

function Main (name)
	local file = io.open (name, "r") -- load version

	if file then
		local line = file:read ("*line")
		file:close ()

		if line and # line > 0 then
			sets.vers = line:sub (4)
			sets.vers = sets.vers:gsub ("[\r\n]+", "")
		end
	end

	local path = name:match ("^(.+/)[^/]+$") -- load towns
	math.randomseed (os.time ())

	if path then
		path = path .. conf.file
		local file = io.open (path, "r")

		if file then
			file:close ()
			local list = {}

			for town in io.lines (path) do
				if # town >= 2 then
					local lown = town:gsub ("[\r\n]+", "")
					lown = lown:gsub (string.char (32), string.char (45))
					table.insert (list, lower (lown))
				end
			end

			if # list > 0 then
				for pos = # list, 1, -1 do
					local new = math.random (pos)
					list [pos], list [new] = list [new], list [pos]
				end

				for _, town in pairs (list) do
					local lett = town:sub (1, 1)

					if not sets.town [lett] then
						sets.town [lett] = {}
					end

					sets.town [lett][town] = false
					sets.name = sets.name + 1
				end

			else
				-- todo: warn and disable
			end
		end
	end

	conf.nick = conf.nick:gsub (string.char (32), string.char (160))
	VH:RegBot (conf.nick, 3, sets.vers, string.char (2), "", 0) -- away
	local save = conf.chat

	if not save then
		conf.chat = true
	end

	chat (lang [conf.lang].vers:format (sets.vers, sets.name) .. "\r\n\r\n " .. lang [conf.lang].mode .. "\r\n " .. lang [conf.lang].star .. "\r\n " .. lang [conf.lang].quit:format (conf.trig.main) .. "\r\n " .. lang [conf.lang].stop:format (conf.exit) .. "\r\n\r\n " .. (save and lang [conf.lang].chat or lang [conf.lang].room) .. "\r\n")

	if not save then
		conf.chat = false
	end

	VH:SQLQuery ("create table if not exists `lua_towns_stat` (`nick` varchar(255) not null primary key, `score` bigint(20) unsigned not null default 1)")
	local _, rows = VH:SQLQuery ("select * from `lua_towns_stat`")

	if rows > 0 then
		for row = 0, rows - 1 do
			local _, user, scor = VH:SQLFetch (row)
			sets.stal [user] = tonumber (scor)
		end
	end

	return 1
end

function UnLoad (code)
	if not sets.load then
		return 1
	end

	conf.chat = true
	sets.play = {}
	chat (lang [conf.lang].load)
	VH:UnRegBot (conf.nick)
	return 1
end

function VH_OnUserLogin (nick, addr)
	if VH.InUserSupports then
		local _, flag = VH:InUserSupports (nick, "UserCommand")

		if tonumber (flag) == 0 then
			return
		end
	end

	VH:SendToUser ("$UserCommand 1 3 " .. nmdc (conf.menu) .. "\\" .. lang [conf.lang].leav .. " $<%[mynick]> " .. conf.trig.main .. "&#124;|", nick)
	VH:SendToUser ("$UserCommand 1 3 " .. nmdc (conf.menu) .. "\\" .. lang [conf.lang].list .. " $<%[mynick]> " .. conf.trig.main .. " " .. conf.trig.list .. "&#124;|", nick)
	VH:SendToUser ("$UserCommand 1 3 " .. nmdc (conf.menu) .. "\\" .. lang [conf.lang].stat .. " $<%[mynick]> " .. conf.trig.main .. " " .. conf.trig.best .. "&#124;|", nick)
	VH:SendToUser ("$UserCommand 1 3 " .. nmdc (conf.menu) .. "\\" .. lang [conf.lang].help .. " $<%[mynick]> " .. conf.trig.main .. " " .. conf.trig.help .. "&#124;|", nick)

	if class (nick) >= conf.clas then
		VH:SendToUser ("$UserCommand 0 3|", nick)
		VH:SendToUser ("$UserCommand 1 3 " .. nmdc (conf.menu) .. "\\" .. lang [conf.lang].chan .. " $<%[mynick]> " .. conf.trig.main .. " " .. conf.trig.mode .. "&#124;|", nick)
		VH:SendToUser ("$UserCommand 1 3 " .. nmdc (conf.menu) .. "\\" .. lang [conf.lang].work .. " $<%[mynick]> " .. conf.trig.main .. " " .. conf.trig.work .. "&#124;|", nick)
	end

	return 1
end

function VH_OnHubCommand (nick, data, oper, priv)
	if data:sub (1, # conf.trig.main) ~= conf.trig.main then
		return 1
	end

	local trig = data:sub (# conf.trig.main + 2)
	local clas = class (nick)

	if trig == conf.trig.work then -- work
		if clas < conf.clas then
			reply (lang [conf.lang].clas, nick, (priv == 1))
			return 0
		end

		if sets.load then
			stop (lang [conf.lang].load, true)

		else
			VH:RegBot (conf.nick, 3, sets.vers, string.char (2), "", 0) -- away
			local save = conf.chat

			if not save then
				conf.chat = true
			end

			chat (lang [conf.lang].vers:format (sets.vers, sets.name) .. "\r\n\r\n " .. lang [conf.lang].mode .. "\r\n " .. lang [conf.lang].star .. "\r\n " .. lang [conf.lang].quit:format (conf.trig.main) .. "\r\n " .. lang [conf.lang].stop:format (conf.exit) .. "\r\n " .. (save and lang [conf.lang].chat or lang [conf.lang].room) .. "\r\n")

			if not save then
				conf.chat = false
			end

			sets.load = true
		end

		return 0
	end

	if trig == conf.trig.mode then -- mode
		if clas < conf.clas then
			reply (lang [conf.lang].clas, nick, (priv == 1))
			return 0
		end

		sets.play = {}

		if conf.chat then -- room mode
			chat (lang [conf.lang].room)
			conf.chat = false

		else -- chat mode
			conf.chat = true
			chat (lang [conf.lang].chat)
		end

		sets.user = 0
		VH:EditBot (conf.nick, 3, sets.vers, string.char (conf.chat and 1 or 2), "", sets.user) -- away
		return 0
	end

	if trig == conf.trig.list then -- list
		local list = ""

		for nick, _ in pairs (sets.play) do
			list = list .. " " .. nick .. " @ " .. _tostring (sets.stat [nick] or 0) .. " / " .. _tostring (sets.stal [nick] or 0) .. "\r\n"
		end

		if # list > 0 then
			reply ((conf.chat and lang [conf.lang].left or lang [conf.lang].list) .. ":\r\n\r\n" .. list, nick, (priv == 1))
		elseif conf.chat then
			reply (lang [conf.lang].many, nick, (priv == 1))
		else
			reply (lang [conf.lang].none, nick, (priv == 1))
		end

		return 0
	end

	if trig == conf.trig.best then -- best
		stats (nick, (priv == 1))
		return 0
	end

	if trig == conf.trig.help or # trig > 0 then -- help
		local help = lang [conf.lang].help .. ":\r\n\r\n"
		help = help .. " " .. conf.trig.main .. "\t\t- " .. lang [conf.lang].leav .. "\r\n"
		help = help .. " " .. conf.trig.main .. " " .. conf.trig.list .. "\t- " .. lang [conf.lang].list .. "\r\n"
		help = help .. " " .. conf.trig.main .. " " .. conf.trig.best .. "\t- " .. lang [conf.lang].stat .. "\r\n"
		help = help .. " " .. conf.trig.main .. " " .. conf.trig.help .. "\t- " .. lang [conf.lang].help .. "\r\n"

		if class (nick) >= conf.clas then
			help = help .. "\r\n"
			help = help .. " " .. conf.trig.main .. " " .. conf.trig.mode .. "\t- " .. lang [conf.lang].chan .. "\r\n"
			help = help .. " " .. conf.trig.main .. " " .. conf.trig.work .. "\t- " .. lang [conf.lang].work .. "\r\n"
			help = help .. "\r\n"
			help = help .. " " .. (conf.chat and lang [conf.lang].chat or lang [conf.lang].room) .. "\r\n"
		end

		reply (help, nick, (priv == 1))
		return 0
	end

	if not sets.load then
		return 1
	end

	if conf.chat then -- chat mode
		if sets.play [nick] then -- enter
			sets.play [nick] = nil
			chat (lang [conf.lang].play:format (sets.stat [nick] or 0, sets.stal [nick] or 0, nick))

		else -- leave
			chat (lang [conf.lang].exit:format (sets.stat [nick] or 0, sets.stal [nick] or 0, nick))
			sets.play [nick] = true
		end

	else -- room mode
		if sets.play [nick] then -- leave
			chat (lang [conf.lang].exit:format (sets.stat [nick] or 0, sets.stal [nick] or 0, nick))
			sets.user = sets.user - 1
			VH:EditBot (conf.nick, 3, sets.vers, string.char (1), "", sets.user)
			sets.play [nick] = nil

		else -- enter
			sets.play [nick] = true
			chat (lang [conf.lang].play:format (sets.stat [nick] or 0, sets.stal [nick] or 0, nick))
			sets.user = sets.user + 1
			VH:EditBot (conf.nick, 3, sets.vers, string.char (1), "", sets.user)
		end
	end

	return 0
end

function VH_OnParsedMsgChat (nick, data)
	if not sets.load then
		return 1
	end

	local word = data:match ("^%s*(%S+)%s*$")

	if not word or # word < 2 then
		return 1
	end

	word = lower (word) -- todo: allow few mistakes
	local lett = word:sub (1, 1)

	if not sets.town [lett] or (# sets.lett > 0 and sets.lett ~= lett) then
		return 1
	end

	if conf.prox then -- check ip for proxy using ledokol
		local _, addr = VH:GetUserIP (nick)

		if # addr > 0 then
			local prox = sets.prox [addr]

			if not prox then
				sets.prox [addr] = 0
				VH:ScriptCommand ("is_ip_proxy", addr)

			elseif prox == 0 then
				VH:ScriptCommand ("is_ip_proxy", addr)

			elseif prox == 1 then
				reply (lang [conf.lang].prox, nick)
				return 0
			end
		end
	end

	for town, same in pairs (sets.town [lett]) do
		if town == word then
			if not conf.chat then -- room mode
				reply (lang [conf.lang].room, nick)
				return 1
			end

			if sets.play [nick] then
				sets.play [nick] = nil
				chat (lang [conf.lang].play:format (sets.stat [nick] or 0, sets.stal [nick] or 0, nick))
			end

			chat (data, nick)

			if same then
				chat (lang [conf.lang].same:format (nick))

			else
				VH:SQLQuery ("insert into `lua_towns_stat` (`nick`) values ('" .. sql (nick) .. "') on duplicate key update `score` = `score` + 1")
				sets.stat [nick] = (sets.stat [nick] or 0) + 1
				sets.stal [nick] = (sets.stal [nick] or 0) + 1
				sets.town [lett][town] = true
				sets.lett = next (town)

				if # sets.lett > 0 then
					chat (lang [conf.lang].next:format (nick, town, sets.stat [nick], sets.stal [nick], upper (sets.lett)))
				end
			end

			sets.last = os.time ()
			sets.hint = 0
			return 0
		end
	end

	return 1
end

function VH_OnParsedMsgPM (nick, data, user)
	if user ~= conf.nick or not sets.load then
		return 1
	end

	if VH_OnHubCommand (nick, data, 0, 1) == 0 then
		return 0
	end

	if conf.chat then
		reply (lang [conf.lang].chat, nick, true)
		return 0
	end

	local word = data:match ("^%s*(%S+)%s*$")

	if not word or # word < 2 then
		if conf.talk and sets.play [nick] then
			chat (data, nick)
		end

		return 0
	end

	word = lower (word) -- todo: allow few mistakes
	local lett = word:sub (1, 1)

	if not sets.town [lett] or (# sets.lett > 0 and sets.lett ~= lett) then
		if not sets.play [nick] then
			reply (lang [conf.lang].star, nick, true)
		elseif conf.talk then
			chat (data, nick)
		end

		return 0
	end

	if conf.prox then -- check ip for proxy using ledokol
		local _, addr = VH:GetUserIP (nick)

		if # addr > 0 then
			local prox = sets.prox [addr]

			if not prox then
				sets.prox [addr] = 0
				VH:ScriptCommand ("is_ip_proxy", addr)

			elseif prox == 0 then
				VH:ScriptCommand ("is_ip_proxy", addr)

			elseif prox == 1 then
				reply (lang [conf.lang].prox, nick, true)
				return 0
			end
		end
	end

	for town, same in pairs (sets.town [lett]) do
		if town == word then
			chat (data, nick)

			if not sets.play [nick] then
				sets.play [nick] = true
				chat (lang [conf.lang].play:format (sets.stat [nick] or 0, sets.stal [nick] or 0, nick))
				sets.user = sets.user + 1
				VH:EditBot (conf.nick, 3, sets.vers, string.char (1), "", sets.user)
			end

			if same then
				chat (lang [conf.lang].same:format (nick))

			else
				VH:SQLQuery ("insert into `lua_towns_stat` (`nick`) values ('" .. sql (nick) .. "') on duplicate key update `score` = `score` + 1")
				sets.stat [nick] = (sets.stat [nick] or 0) + 1
				sets.stal [nick] = (sets.stal [nick] or 0) + 1
				sets.town [lett][town] = true
				sets.lett = next (town)

				if # sets.lett > 0 then
					chat (lang [conf.lang].next:format (nick, town, sets.stat [nick], sets.stal [nick], upper (sets.lett)))
				end
			end

			sets.last = os.time ()
			sets.hint = 0
			return 0
		end
	end

	if not sets.play [nick] then
		reply (lang [conf.lang].star, nick, true)
	elseif conf.talk then
		chat (data, nick)
	end

	return 0
end

function VH_OnTimer (msec)
	if not sets.load or # sets.lett == 0 then
		return 1
	end

	local dif = os.difftime (os.time (), sets.last)

	if sets.hint < conf.help and dif >= conf.hint then -- show hint
		if sets.town [sets.lett] then
			for town, same in pairs (sets.town [sets.lett]) do
				if not same then
					sets.town [sets.lett][town] = true
					sets.lett = next (town)

					if # sets.lett > 0 then
						chat (lang [conf.lang].hint:format (town, upper (sets.lett)))
						sets.hint = sets.hint + 1
						sets.last = os.time ()
					end

					break
				end
			end

			if # sets.lett == 0 then
				return 1
			end

		else
			stop (lang [conf.lang].lett)
		end

		return 1
	end

	if dif >= conf.exit then -- stop game
		stop (lang [conf.lang].miss)
		VH:EditBot (conf.nick, 3, sets.vers, string.char (2), "", 0) -- away
		return 1
	end

	return 1
end

function VH_OnScriptCommand (name, data, plug, file) -- check ip for proxy using ledokol
	if conf.prox and plug == "lua" and file:sub (-11) == "ledokol.lua" and name == "ip_is_proxy" and # data > 0 and sets.prox [data] == 0 then
		sets.prox [data] = 1
	end

	return 1
end

-- end of file